import matplotlib.pyplot as plt


cnn_mnist_r_60_case1 = [19,14,9,10,6,2]
cnn_mnist_r_60_case2 = [12,5,4,3,3,1]
cnn_mnist_r_60_case3 = [89,100,100,100,100,100]
cnn_mnist_r_60_case4 = [5,3,3,2,1,1]

cifar_r_60_case1 = [22,17,12,8,5,2]
cifar_r_60_case2 = [9,3,2,4,3,1]
cifar_r_60_case3 = [66,86,85,100,83,83]
cifar_r_60_case4 = [7,4,3,2,3,1]


selected_R = [5, 10, 15, 30, 45, 60]

label_fontsize = 30 
tick_fontsize = 25  #
legend_fontsize = 20  


plt.rcParams['font.family'] = 'Times New Roman'  
plt.rcParams['figure.autolayout'] = True  


plt.figure(figsize=(10, 6))
plt.plot(selected_R, cnn_mnist_r_60_case1, label='CNN MNIST Case 1', marker='o')
plt.plot(selected_R, cnn_mnist_r_60_case2, label='CNN MNIST Case 2', marker='o')
plt.plot(selected_R, cnn_mnist_r_60_case3, label='CNN MNIST Case 3', marker='o')
plt.plot(selected_R, cnn_mnist_r_60_case4, label='CNN MNIST Case 4', marker='o')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Value of $\\tau*$', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)


plt.savefig('cnn_mnist_r_60_selected_plot.pdf')
plt.savefig('cnn_mnist_r_60_selected_plot.svg')
plt.savefig('cnn_mnist_r_60_selected_plot.png', dpi=300)


plt.show()


plt.figure(figsize=(10, 6))
plt.plot(selected_R, cifar_r_60_case1, label='CNN CIFAR-10 Case 1', marker='o')
plt.plot(selected_R, cifar_r_60_case2, label='CNN CIFAR-10 Case 2', marker='o')
plt.plot(selected_R, cifar_r_60_case3, label='CNN CIFAR-10 Case 3', marker='o')
plt.plot(selected_R, cifar_r_60_case4, label='CNN CIFAR-10 Case 4', marker='o')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Value of $\\tau*$', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)


plt.savefig('cifar_r_60_selected_plot.pdf')
plt.savefig('cifar_r_60_selected_plot.svg')
plt.savefig('cifar_r_60_selected_plot.png', dpi=300)


plt.show()
